local function initExperimentalCarStuff()
if not getDebug() or isClient() or isServer() then return end

local WayMoreCarsExtraOptions = PZAPI.ModOptions:getOptions("WayMoreCarsExtraOptionsID")
local jumpCars = WayMoreCarsExtraOptions:getOption("jumpCarsID")
local launchCars = WayMoreCarsExtraOptions:getOption("launchCarsID")
local carsConditional = WayMoreCarsExtraOptions:getOption("carsCondID")

local scripts = getScriptManager():getAllVehicleScripts()
local burntVehicles   = {}
local smashedVehicles = {}
for i = 1, scripts:size() do
	local script = scripts:get(i - 1)
	local name   = string.lower(script:getName())
	if string.find(name, "burnt") then
		table.insert(burntVehicles, script:getFullName())
	elseif string.find(name, "smashed") then
		table.insert(smashedVehicles, script:getFullName())
	end
end
local function getRandomFromTable(t)
	if not t or #t == 0 then return nil end
	return t[ZombRand(#t) + 1]
end

local function getVehicleDir(vehicle)
	local y = vehicle:getAngleY()
	if y < 0.00001 and y > -0.00001 then y = 0.0001 end
	local angle = y - 90
	if math.abs(vehicle:getAngleZ()) > 90 then  angle = 90 - y end
	return -angle*(math.pi/180)
end
local function worldToVehicleLocal(dx, dy, vehicle)
	local theta = getVehicleDir(vehicle)

	local cosT = math.cos(theta)
	local sinT = math.sin(theta)

	local localX =  dx * cosT + dy * sinT
	local localY = -dx * sinT + dy * cosT

	return localX, localY
end
local function getSmashSideFromBomb(vehicle, square)
	local dx = square:getX() - vehicle:getX()
	local dy = square:getY() - vehicle:getY()

	local lx, ly = worldToVehicleLocal(dx, dy, vehicle)

	if math.abs(lx) > math.abs(ly) then
		if lx > 0 then
			return "N"
		else
			return "S"
		end
	else
		if ly > 0 then
			return "E"
		else
			return "W"
		end
	end
end

local function funcLaunchCars(vehicle, square)
	local i = -1
	local function jumpCarFirst()
		i = i + 1
		if i <= 3 then
			vehicle:onJump()
		end
		if i <= 4 then return end
		vehicle:onHitLandmine(square)
		Events.OnTick.Remove(jumpCarFirst)
	end
	Events.OnTick.Add(jumpCarFirst)
end

local function scanVehiclesInRadius(x, y, z, radius, vehicle, setBombAction, setJumpCar, setLaunchCar)
	if not (x and y and z) then return end
	local cell = getCell()
	local square = cell:getOrCreateGridSquare(x, y, z)
	local seen = {}
	local r2 = radius * radius
	for dx = -radius, radius do
		for dy = -radius, radius do
			local hitPoint = (dx * dx + dy * dy)
			if hitPoint <= r2 then
				local sq0 = cell:getGridSquare(x + dx, y + dy, z)
				if sq0 then
					local vehicles = sq0:getVehicleContainer()
					if vehicles ~= nil and not seen[vehicles] then
						seen[vehicles] = true
						if vehicle and vehicles ~= vehicle then

							if setBombAction then
				--				local rand = newrandom()
							--	print(hitPoint)
				--				local radiusDamage = setBombAction[1]
							--	print(radiusDamage^2)
				--				local radiusFling = setBombAction[2]
							--	print(radiusFling^2)
				--				local radiusJump = setBombAction[3]
							--	print(radiusJump^2)
								local radiusAlarm = setBombAction[4]
							--	print(radiusAlarm^2)
				--				if radiusDamage and hitPoint <= radiusDamage^2 then
				--					local randCarDamaged = rand:random(1, 100)
				--					if randCarDamaged <= 50 then
				--						if not vehicles:isBurnt() and not string.contains(string.lower(vehicles:getScriptName()), "trailer") then
				--							vehicles:setAlarmed(false)
				--							local vDir = { vehicles:getAngleX(), vehicles:getAngleY(), vehicles:getAngleZ(), vehicles:getDebugZ() }
				--							local vPos = { vehicles:getX(), vehicles:getY(), vehicles:getZ() }
				--							vehicles:permanentlyRemove()
				--							local i = 2
				--							local function replaceBurnt()
				--								i = i - 1
				--								if i <= 0 then
				--									vehicles = addVehicle(getRandomFromTable(burntVehicles), vPos[1], vPos[2], vPos[3])	--should pick out a burnt vehicle tied to the vehicle it matches best with
				--									vehicles:setDebugZ(vDir[4])
				--									vehicles:setAngles(vDir[1], vDir[2], vDir[3])
				--									Events.OnTick.Remove(replaceBurnt)
				--								end
				--							end
				--							Events.OnTick.Add(replaceBurnt)
				--						end
							-- works-ish, can't set smashed, but I have the correct side. Can reuse functions, burnt will do for here.
								--	elseif randCarDamaged <= 0 then
								--		local smashSide = getSmashSideFromBomb(vehicles, square)
								--		vehicles:setSmashed(smashSide)
				--					end
				--				end
				--				if radiusFling and hitPoint <= radiusFling^2 then
				--					if not vehicles:isBurnt() and not string.contains(string.lower(vehicles:getScriptName()), "trailer") then
				--						funcLaunchCars(vehicles, square)
				--					end
				--				end
								if radiusJump and hitPoint <= radiusJump^2 then
									vehicles:onJump()
								end
								if radiusAlarm and hitPoint <= radiusAlarm^2 then
									local i = 2
									local function ifReplaceBurnt()
										i = i - 1
										if i <= 0 then
											if not vehicles:isBurnt() and not vehicles:isSmashed() and not string.contains(string.lower(vehicles:getScriptName()), "trailer") then
												if vehicles:isAlarmed() then --or vehicles:areAllDoorsLocked() --extra punishing
												--	vehicles:setAlarmed(true)
													vehicles:triggerAlarm()
												end
											end
											Events.OnTick.Remove(ifReplaceBurnt)
										end
									end
									Events.OnTick.Add(ifReplaceBurnt)
								end

							elseif setJumpCar then
								vehicles:onJump()
							elseif setLaunchCar then
								funcLaunchCars(vehicles, square)
							end
							
						end
					end
				end
			end
		end
	end
end

local function explodeVehicles(throwable, square)
--	print(throwable:getExplosionSound())
--	print(throwable:getExplosionPower())
--	print(throwable:getExplosionRange())
	local bombType = throwable:getExplosionSound()		--VANILLA VALUES: power, radius
	local radius										--2 minimum (radius) because 1 is nearly impossible to hit
	local damageType
	if bombType == "PipeBombExplode" then 										--90, 7
		radius = 20	--2 set burnt, 5 to fling, 10 to jump, 20 to set off alarms
		damageType = {2, 5, 10, 20}
	elseif bombType == "AerosolBombExplode" then								--70, 6
		radius = 12	--2 set burnt, 3 to fling, 6 to jump, 12 to set off alarms
		damageType = {2, 3, 6, 12}
	elseif bombType == "MolotovCocktailExplode" then 							--0, 0
		radius = 3	--set burnt or set alarm
		damageType = {3, nil, nil, 2}
	elseif bombType == "FlameTrapExplode" then									--0, 0
		radius = 5	--set burnt or set alarm
		damageType = {5, nil, nil, 2}
--	elseif bombType == "FireCrackerExplode" then								--0, 0
--		return
--	elseif bombType == "FireCrackerSingleExplode" then							--0, 0
--		return
--	elseif bombType == "SmokeBombLoop" then										--0, 0
--		return
--	elseif bombType == "NoiseMakerActivate" then								--0, 0
--		return
	else
		return
	end
	scanVehiclesInRadius(square:getX(), square:getY(), square:getZ(), radius, nil, damageType, false, false)
end
--Events.OnThrowableExplode.Add(explodeVehicles)

local function onPlayerUpdate(player)
	if isKeyDown(carsConditional:getValue()) then
		if isKeyPressed(jumpCars:getValue()) then
			local vehicle = player:getVehicle()
			if vehicle then
				scanVehiclesInRadius(vehicle:getX(), vehicle:getY(), vehicle:getZ(), 10, vehicle, nil, true, false)
			end
		elseif isKeyPressed(launchCars:getValue()) then
			local vehicle = player:getVehicle()
			if vehicle then
				scanVehiclesInRadius(vehicle:getX(), vehicle:getY(), vehicle:getZ(), 10, vehicle, nil, false, true)
			end
		end
	elseif isKeyPressed(jumpCars:getValue()) then
		local vehicle = player:getVehicle()
		if vehicle then
			vehicle:onJump()
		end
	elseif isKeyPressed(launchCars:getValue()) then
		local vehicle = player:getVehicle()
		if vehicle then
			local square = getCell():getOrCreateGridSquare(vehicle:getX(), vehicle:getY(), vehicle:getZ())
			if square then
				vehicle:onHitLandmine(square)
			end
		end
	end
end
Events.OnPlayerUpdate.Add(onPlayerUpdate)

end
Events.OnInitGlobalModData.Add(initExperimentalCarStuff)
